//=============================================================================
// Extra maps
// Zeriab_ExtraMaps.js
// Last Updated: 2015.08.23
//=============================================================================

/*:
 * @plugindesc Allows using more than 999 maps
 * @author Zeriab
 *
 * @help
 *
 * Plugin Command:
 *   setmap set church   # Use maps from the specific "church" subfolder (data/church/Map003.json)
 *   setmap reset        # Use maps from the default folder (data/Map003.json)
 *
 *   Next transfer will use maps from the new folder
 */
/*:ja
 * @plugindesc 999以上のマップ使用を可能にします。
 * @author Zeriab
 *
 * @help　プラグインコマンドは以下を参照してください。
 *
 * Plugin Command:
 *   ExtraMaps set church   # 
 * 	"church"のサブフォルダからマップを使用します(data/church/Map003.json)
 *   ExtraMaps reset        # 
 * 	デフォルトのフォルダからマップを使用します(data/Map003.json)
 *
 */


(function() {
	getmapfolder = function(subfolder, filename) {
	//	return '%1/%2'.format(subfolder, filename);
		return 'LDP1000Maps/data/%1'.format(filename);
	}
	
	var newmaps_Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) {
		newmaps_Game_Interpreter_pluginCommand.call(this, command, args);
		if (command.toLowerCase() === "setmap") {
			//setmap 1
			//setmap 		//clears
			
			if (args[0]) {
				$gameSystem.setMapsFolder(args[0]);
			}
			else {
				$gameSystem.clearMapsFolder();
			}
		}
	};

	Game_System.prototype.setMapsFolder = function(subfolder) {
		if (this._MapSubFolder !== subfolder)
		{
			this._MapSubFolder = subfolder;
			this._MapFolderChange = true;
		}
	};

	Game_System.prototype.clearMapsFolder = function() {
		this.setMapsFolder('');
	};


	// Overriding: DataManager.loadMapData
	DataManager.loadMapData = function(mapId) {
		subfolder = $gameSystem._MapSubFolder || '';
		if (mapId > 0) {
			//makeMapName
			
			var filename = 'Map%1.json'.format(mapId.padZero(3));
			if (subfolder && subfolder.length >= 1)
			{
				filename = getmapfolder(subfolder, filename)
			}
			
			this.loadDataFile('$dataMap', filename);
		} else {
			this.makeEmptyMap();
		}
		// Extra check needed since we need to reload the map transferring
		// to a different folder with unchanged mapId.
		DataManager.checkMapFolderReload();
	};


//replaces method in YEP_CallEvent
DataManager.loadCallMapData = function(mapId) {
	subfolder = $gameSystem._MapSubFolder || '';
	if (mapId > 0) {
		var filename = 'Map%1.json'.format(mapId.padZero(3));
		if (subfolder && subfolder.length >= 1)
		{
			filename = getmapfolder(subfolder, filename)
		}
		
		this.loadDataFile('$callEventMap', filename);
	}
	else {
		$callEventMap = {};
		$callEventMap.data = [];
		$callEventMap.events = [];
		$callEventMap.width = 100;
		$callEventMap.height = 100;
		$callEventMap.scrollType = 3;
	}
};



	DataManager.checkMapFolderReload = function() {
		reloadNeeded = $gameSystem._MapFolderChange || false;
		if (reloadNeeded)
		{
			$gamePlayer.requestMapReload();	
		}
	};
})();
